;Cubemapped Terrain used for Water
;by JFK / CSP Games
; (it's not very modular yet since there are some Gobals in use, sorry ppl)
; please note: this is not perfect, colors still look unnatural, obejcts still have to be
; over the water level to prevent mirroring artefacts. (submarine is boolean cut off in the middle)

Graphics3D 800,600,32,1 ; min resolution is (3*256) * (2*256) Pixel due to cubemapping optimation
SetBuffer BackBuffer()



;setup cubemapping
Global cube_sunglasses=CreateCube() ; this "sunglasses" is used to darken the cubemap for blendmode 3
EntityFX cube_sunglasses,1 ; it's a simple alphaed black cube around the cubemap cams
FlipMesh cube_sunglasses
EntityColor cube_sunglasses,0,0,0
EntityAlpha cube_sunglasses,0.2
ScaleEntity cube_sunglasses,10,10,10


cubetex=CreateTexture(256,256,1 + 128 + 256)
size=TextureWidth(cubetex)

; Create cubemap cameraS (we use 6 cams )
Dim cubecam(5)
For i=0 To 5
 cubecam(i) = CreateCamera()
 CameraClsMode cubecam(i),False,True
 CameraRange cubecam(i),1,15000
 HideEntity cubecam(i)
Next
; we gonna render them in one step, two rows of 3 viewports, indexed as:
; 012
; 345
RotateEntity cubecam(0),0,90,0 ; right
CameraViewport cubecam(0),0,0,size,size
RotateEntity cubecam(1),0,0,0 ; forw
CameraViewport cubecam(1),size,0,size,size
RotateEntity cubecam(2),0,-90,0 ; left
CameraViewport cubecam(2),size*2,0,size,size
RotateEntity cubecam(3),0,180,0 ; back
CameraViewport cubecam(3),0,size,size,size
RotateEntity cubecam(4),-90,0,0 ; up
CameraViewport cubecam(4),size,size,size,size
RotateEntity cubecam(5),90,0,0 ; down
CameraViewport cubecam(5),size*2,size,size,size




; set up world basics
Global camera=CreateCamera()
CameraRange camera,1,10000
light=CreateLight()
RotateEntity light,45,45,45
center=CreatePivot() ; used to point camera to etc.


;load a skybox  (had some troubles with this mesh, so ignore the mess)
ClearTextureFilters
TextureFilter "",9 Or 48
Global skybox=LoadMesh("skybox\skybox.3ds")
ClearTextureFilters
TextureFilter "",9
FitMesh skybox,-50,-50,-50,100,100,100
EntityOrder skybox,1
c=CountSurfaces(skybox)
For i=1 To c
 s=GetSurface(skybox,i)
 b=GetSurfaceBrush(s)
 BrushFX b,1+4
 PaintSurface s,b
Next



; make a terrain for the water animation (LOD!)
Global sea_wave#
ter_x=128 ; number of (water-)terrain segments (128*128*2 is virtually 32768 tris)
ter_s#=50 ; (water-)terrain scaling factor
Global sea=CreateTerrain(ter_x)
TerrainDetail sea,5000,0
ScaleEntity sea,ter_s#,ter_s#,ter_s#
PositionEntity sea,-(.5*ter_x*ter_s),0,-(.5*ter_x*ter_s)
TerrainShading sea,1
EntityFX sea,1


; load an animated texture for the 2nd texture layer of the water
ani_width=128
ani_height=128
ani_frames=15
tex=LoadAnimTexture("ddtestdd.jpg",0,ani_width,ani_height,0,ani_frames)
ScaleTexture tex,15,15


;define texture blend modes etc.
EntityTexture sea,tex,0,0
EntityTexture sea,cubetex,0,1

TextureBlend cubetex,3 ; 3
TextureBlend tex,2 ; 2
EntityColor sea,200,200,200 ; acts as a mixing value (the darker, the less influence)

; and object to me mirrored
dummy=LoadMesh("submarn1e.3ds")
sub_b=LoadTexture("tek2.jpg")
ScaleTexture sub_b,.4,.1
EntityTexture dummy,sub_b
ScaleEntity dummy,30,60,30
EntityShininess dummy, 0.25 
EntityColor dummy,100,100,100
EntityFX dummy,16




a#=180
; ************************************  MAIN DEMO LOOP  **************************************
While KeyDown(1)=0
 a#=(a+.1) Mod 360
 a2#=120 ;(a2+1) Mod 360
 PositionEntity camera, Sin(a)*(.5*ter_x*ter_s),250,Cos(a)*(.5*ter_x*ter_s)
 PositionEntity dummy, Sin(a2*2)*2000.0,100,Cos(a2*2)*2000.0
 PointEntity camera, center

 ; update animated texture
 If MilliSecs()>ttt
  ttt=MilliSecs()+33
  EntityTexture sea,tex,count,0
  count=count+1
  If count>=ani_frames Then count=0
 EndIf
 ;
 ; update the terrains water animation: parameters are: speed#,smallness#,height#
 UpdateWaves(sea,0.005,150.0,0.2) ; small flat waves, best IMHO
  ;UpdateWaves(sea,0.05,25.0,.5) ; eg: mid sized waves
  ;UpdateWaves(sea,0.1,5.0,.5) ; eg: big, even waves
 UpdateWorld()
 UpdateCubemap%(cubetex)
 RotateEntity skybox,0,0,0,1
 PositionEntity skybox,EntityX(camera,1),EntityY(camera,1),EntityZ(camera,1),1
 RenderWorld()
 VWait:Flip 0
Wend
End




Function UpdateWaves(ter,stormy#=0.3,wavesize#=10.0,waveheight#=1.0)
 ter_x=TerrainSize(ter)
 For j=0 To ter_x
  For i=0 To ter_x
   v#=0.5+((Sin((sea_wave#+i)*wavesize#)*Cos((sea_wave#+j)*wavesize#*1.7))/6.0)+((Sin((sea_wave#+i)*wavesize#*2.7)*Cos((sea_wave#+j)*wavesize#*5))/6.0)+((Sin((sea_wave#+i)*wavesize#*15.0)*Cos((sea_wave#+j)*wavesize#*11.0))/6.0)
   If v<0 Then v=0
   If v>1.0 Then v=1.0
   v=v*waveheight#
   ModifyTerrain ter,i,j,v#,0
  Next
 Next
 sea_wave#=(sea_wave#+stormy#) Mod 360
End Function





Function UpdateCubemap%(texture%)
	Local size%
	size = TextureWidth(texture)
	HideEntity sea
    HideEntity camera
    x#=EntityX(camera,1)
    y#=EntityY(sea,1)-EntityY(camera,1)
    z#=EntityZ(camera,1)
    PositionEntity skybox,x,y,z,1
    ShowEntity cube_sunglasses
    PositionEntity cube_sunglasses,x,y,z,1
	For i=0 To 5
     ShowEntity cubecam(i)
     PositionEntity cubecam(i),x,y,z,1
	Next
	RenderWorld()
    HideEntity cube_sunglasses
	SetCubeFace texture,0
	CopyRect 0,0,size,size,0,0,BackBuffer(),TextureBuffer(texture)
	SetCubeFace texture,1
	CopyRect size,0,size,size,0,0,BackBuffer(),TextureBuffer(texture)
	SetCubeFace texture,2
	CopyRect size*2,0,size,size,0,0,BackBuffer(),TextureBuffer(texture)
	SetCubeFace texture,3
	CopyRect 0,size,size,size,0,0,BackBuffer(),TextureBuffer(texture)
	SetCubeFace texture,4
	CopyRect size,size,size,size,0,0,BackBuffer(),TextureBuffer(texture)
	SetCubeFace texture,5
	CopyRect size*2,size,size,size,0,0,BackBuffer(),TextureBuffer(texture)
	ShowEntity sea
	For i=0 To 5
	 HideEntity cubecam(i)
	Next
    ShowEntity camera
End Function